﻿//////////////////////////////////////////////
// ProjectSaveQuery.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class ResourceDeclAugmentCallback ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

// nkGraphics
#include <NilkinsGraphics/Resources/ResourceSetSaveQuery.h>

// nkMemory
#include <NilkinsMemory/Containers/String.h>

// nkScripts
#include <NilkinsScripts/Exporter/Project/ProjectSaveQuery.h>

/// Internals --------------------------------

namespace nkAstraeus
{
	struct ProjectSaveQueryInformation final
	{
		ResourceDeclAugmentCallback* _augmentCallback = nullptr ;

		bool _materials = true ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	struct DLL_ASTRAEUS_EXPORT ProjectSaveQuery final
	{
		// Path, relative to data folder
		// Going to override all paths in children requests
		nkMemory::String _path ;

		// Queries
		ProjectSaveQueryInformation _astraeusQuery ;
		nkGraphics::ResourceSetSaveQuery _graphicsQuery ;
		nkScripts::ProjectSaveQuery _scriptsQuery ;
	} ;
}